<?php

namespace App\Providers;

use App\Currency;
use App\GeneralSettings;
use App\Language;
use App\Menu;
use App\Social;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        $data['lan'] = Language::all();
        $data['basic'] = GeneralSettings::first();
        $data['social'] = Social::all();

        view::share($data);


        View::composer('partials.reserve', function($view){
            $view->with('ourReserves', Currency::orderBy('id','asc')->get());
        });

        View::composer('partials.todays_rate', function ($view){
            $view->with('rates',Currency::where('status',1)->orderBy('id','asc')->get());
        });







        //
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
